package cn.com.duiba.kjy.livecenter.api.remoteservice.statistics;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.statistics.LiveStatisticsAgentDto;
import cn.com.duiba.kjy.livecenter.api.param.statistics.LiveStatisticsAgentSearchParam;

import java.util.List;

/**
 * 代理人纬度直播统计rpc服务
 * @author 吴文哲
 * @date 2020-03-30 15:51
 **/
@AdvancedFeignClient
public interface RemoteLiveStatisticsAgentService {

    /**
     * 根据直播间id 代理人id 获取统计数据
     * @param liveId  直播间id
     * @param agentId 代理人id
     * @return
     */
    LiveStatisticsAgentDto getByLiveIdAndAgentId(Long liveId,Long agentId);

    /**
     * 根据条件获取对应直播间 代理人纬度统计数据
     * @param param
     * @return
     */
    List<LiveStatisticsAgentDto> getListByCondition(LiveStatisticsAgentSearchParam param);

    /**
     * 获取代理人排名
     * 不同直播间状态 统计数据不同
     * @param liveId 直播间id
     * @param agentId 代理人id
     * @return
     */
    Integer getAgentRanking(Long liveId,Long agentId);
}
