/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.livecenter.api.util;

import cn.com.duiba.kjy.livecenter.api.dto.advice.LiveAdviceSessionDto;
import cn.com.duiba.wolf.utils.BlowfishUtils;
import com.alibaba.fastjson.JSON;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;

public class LiveAdviceSessionUtil {
    private static final String SESSION_ENCRYPT = "89a1657cb6a3";

    private LiveAdviceSessionUtil() {
    }

    public static String getSessionKey(Long liveId, Long liveAgentId, Long liveVisitorId) {
        return DigestUtils.md5Hex((String)(liveId + "_" + liveAgentId + "_" + liveVisitorId));
    }

    public static String getSessionId(Long liveId, Long agentId, Long agentLiveUserId, Long visitorLiveUserId) {
        LiveAdviceSessionDto dto = new LiveAdviceSessionDto();
        dto.setLId(liveId);
        dto.setAId(agentId);
        dto.setAVId(agentLiveUserId);
        dto.setVId(visitorLiveUserId);
        return LiveAdviceSessionUtil.getSessionId(dto);
    }

    public static void main(String[] args) {
        System.out.println(LiveAdviceSessionUtil.getSessionId(8L, 38L, 19L, 72L));
    }

    public static String getSessionId(LiveAdviceSessionDto dto) {
        if (dto == null) {
            return "";
        }
        try {
            return BlowfishUtils.encryptBlowfish((String)JSON.toJSONString((Object)dto), (String)SESSION_ENCRYPT);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static LiveAdviceSessionDto getLiveAdviceSessionDto(String sessionId) {
        if (StringUtils.isBlank((CharSequence)sessionId) || "undefined".equals(sessionId) || StringUtils.equals((CharSequence)sessionId, (CharSequence)"null")) {
            return null;
        }
        try {
            String content = BlowfishUtils.decryptBlowfish((String)sessionId, (String)SESSION_ENCRYPT);
            return (LiveAdviceSessionDto)JSON.parseObject((String)content, LiveAdviceSessionDto.class);
        }
        catch (Exception e) {
            return null;
        }
    }
}

