package cn.com.duiba.kjy.livecenter.api.enums.live;

/**
 * 用户预约标识枚举
 * @author liuchao1
 * @version 1.0
 * @date 2020-07-20 09:59
 */
public enum UserAppointmentFlagEnum {

    VISITOR(0, "访客身份标识"),

    AGENT(1, "代理人身份标识"),

    ;

    private Integer code;
    private String desc;

    UserAppointmentFlagEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static UserAppointmentFlagEnum getByCode(Integer code) {
        for (UserAppointmentFlagEnum enumVal : UserAppointmentFlagEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
