package cn.com.duiba.kjy.paycenter.api.dto.payment.response;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 订单取消回执
 * @author 吴文哲
 * @date 2020-07-15 17:53
 **/
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class BaseCancelResponse extends BaseResponse{

    private static final long serialVersionUID = 4555123287231483159L;

    /**
     * 设置错误信息
     * @param cancelResponse 支付单取消回执
     * @param errorMsg 错误信息
     * @return 取消订单回执
     */
    public static  <T extends BaseCancelResponse> T buildErrorMsg(T cancelResponse, String errorMsg) {
        if (cancelResponse == null || errorMsg == null) {
            return cancelResponse;
        }
        cancelResponse.setErrorMsg(errorMsg);
        return cancelResponse;
    }
}
