package cn.com.duiba.kjy.paycenter.api.remoteservice;

import java.util.List;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.paycenter.api.dto.pay.ChargeOrderDto;
import cn.com.duiba.kjy.paycenter.api.dto.payment.request.alipay.AliPayFaceToFaceJsApiRequest;
import cn.com.duiba.kjy.paycenter.api.dto.payment.request.alipay.AliPayWapChargeRequest;
import cn.com.duiba.kjy.paycenter.api.dto.payment.request.bank.hz.HzBankPayChargeRequest;
import cn.com.duiba.kjy.paycenter.api.dto.payment.request.boc.BocPayChargeRequest;
import cn.com.duiba.kjy.paycenter.api.dto.payment.request.ccb.CcbPayChargeRequest;
import cn.com.duiba.kjy.paycenter.api.dto.payment.request.cgb.CgbPayChargeRequest;
import cn.com.duiba.kjy.paycenter.api.dto.payment.request.minsheng.MinshengPayChargeRequest;
import cn.com.duiba.kjy.paycenter.api.dto.payment.request.psbc.PsbcPayChargeRequest;
import cn.com.duiba.kjy.paycenter.api.dto.payment.request.wxpay.WxPayLiteChargeRequest;
import cn.com.duiba.kjy.paycenter.api.dto.payment.request.wxpay.WxPayMpChargeRequest;
import cn.com.duiba.kjy.paycenter.api.dto.payment.response.alipay.AliPayFaceToFaceJsApiResponse;
import cn.com.duiba.kjy.paycenter.api.dto.payment.response.alipay.AliPayWapChargeResponse;
import cn.com.duiba.kjy.paycenter.api.dto.payment.response.bank.hz.HzBankPayChargeResponse;
import cn.com.duiba.kjy.paycenter.api.dto.payment.response.boc.BocPayChargeResponse;
import cn.com.duiba.kjy.paycenter.api.dto.payment.response.ccb.CcbPayChargeResponse;
import cn.com.duiba.kjy.paycenter.api.dto.payment.response.cgb.CgbPayChargeResponse;
import cn.com.duiba.kjy.paycenter.api.dto.payment.response.minsheng.MinshengPayChargeResponse;
import cn.com.duiba.kjy.paycenter.api.dto.payment.response.psbc.PsbcPayChargeResponse;
import cn.com.duiba.kjy.paycenter.api.dto.payment.response.wxpay.WxPayLiteChargeResponse;
import cn.com.duiba.kjy.paycenter.api.dto.payment.response.wxpay.WxPayMpChargeResponse;

/**
 * 支付相关
 * @author lizhi
 * @date 2020/3/3 2:07 PM
 */
@AdvancedFeignClient
public interface RemoteChargeService {

    /**
     * 微信公众号支付收单接口
     *
     * @param chargeRequest 支付请求
     * @return WxPayMpChargeResponse
     */
    WxPayMpChargeResponse createWxPayMpCharge(WxPayMpChargeRequest chargeRequest) throws BizException;

    /**
     * 微信小程序收单接口
     * @param chargeRequest 支付请求
     * @return WxPayLiteChargeResponse
     */
    WxPayLiteChargeResponse createWxPayLiteCharge(WxPayLiteChargeRequest chargeRequest) throws BizException;


    /**
     * 支付宝支付收单接口
     * @param chargeRequest
     * @return
     * @throws BizException
     */
    AliPayWapChargeResponse createAliPayCharge(AliPayWapChargeRequest chargeRequest) throws BizException;

    /**
     * 支付宝当面付-jsapi唤起收银台下单
     * @param chargeRequest 下单参数
     * @return 交易单号
     * @throws BizException 异常
     */
    AliPayFaceToFaceJsApiResponse createFaceToFaceJsApi(AliPayFaceToFaceJsApiRequest chargeRequest) throws BizException;

    /**
     * 建行支付收单接口
     * @param chargeRequest 下单参数
     * @return 收单结果
     * @throws BizException 业务异常
     */
    CcbPayChargeResponse createCcbPayCharge(CcbPayChargeRequest chargeRequest) throws BizException;

    /**
     * 查询支付订单详情
     *
     * @param outTradeNo 支付订单号(商户订单号)
     * @return chargeOrderDto
     */
    ChargeOrderDto findByOutTradeNo(String outTradeNo);

    /**
     * 获取支付订单详情
     * @param bizOrderNo 业务方流水号
     * @param bizType 业务方类型
     * @return ChargeOrderDto
     */
    ChargeOrderDto findByBizOrderNoAndBizType(String bizOrderNo, Integer bizType) throws BizException;

    /**
     * 查询支付订单详情
     *
     * @param outTradeNos 支付订单号
     * @return 支付订单集合
     */
    List<ChargeOrderDto> batchFindByOutTradeNo(List<String> outTradeNos) throws BizException;

    /**
     * 民生银行支付
     *
     * @param chargeRequest charge request
     * @return {@link MinshengPayChargeResponse }
     */
    MinshengPayChargeResponse createMinshengPayCharge(MinshengPayChargeRequest chargeRequest);


    /**
     * 杭州银行支付
     * @param chargeRequest
     * @return
     */
    HzBankPayChargeResponse createHzBankPayCharge(HzBankPayChargeRequest chargeRequest)  throws BizException;

    /**
     * 邮储银行支付
     *
     * @param chargeRequest charge request
     * @return {@link PsbcPayChargeResponse }
     */
    PsbcPayChargeResponse createPsbcPayCharge(PsbcPayChargeRequest chargeRequest);

    /**
     * 广发银行支付
     * @param chargeRequest
     * @return
     */
    CgbPayChargeResponse createCgbPayCharge(CgbPayChargeRequest chargeRequest);


    /**
     * 中行支付下单接口
     * @param chargeRequest 下单参数
     * @return 下单结果
     * @throws BizException 业务异常
     */
    BocPayChargeResponse createBocPayCharge(BocPayChargeRequest chargeRequest) throws BizException;

}
