package cn.com.duiba.kjy.paycenter.api.dto.payment.response.bank.hz;

import cn.com.duiba.kjy.paycenter.api.dto.payment.response.BaseChargeResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * @author: LuHui
 * @date: 2024/6/3 15:00
 * @description:
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class HzBankPayChargeResponse extends BaseChargeResponse {
    private static final long serialVersionUID = -8012155410684889479L;
    /**
     * 商户编号
     */
    private String merId;
    /**
     * 商户名称
     */
    private String merName;
    /**
     * 商户订单号
     */
    private String txnOrderId;
    /**
     * 商户订单发送时间
     */
    private String txnOrderTime;
    /**
     * 商户ID getSignInfo的id
     */
    private String txnUserId;
    /**
     * 商品名称  现金支付-商品名称，积分支付-特殊格式(订单号|活动编号|商品提供商|商品代码|商品名称|商品单价|商品数量|积分账号|积分种类|消耗积分|)
     */
    private String txnOrderBody;
    /**
     * 付款金额 必须有值 单位、分，无金额传0
     */
    private String txnAmt;
    /**
     * 币种 人民币156
     */
    private String txnCcyType;
    /**
     * 前台通知地址
     */
    private String frontEndUrl;
    /**
     * 后台通知地址
     */
    private String backEndUrl;
    /**
     * 支付订单号
     */
    private String txnOrderRealId;
    /**
     * 签名密文
     */
    private String encryptParamInfo;
    /**
     * json
     */
    private String clientParam;

    private String businessData;

}
