package cn.com.duiba.kjy.paycenter.api.dto.payment.response.boc;

import java.io.Serializable;
import java.util.Date;

import lombok.Data;

/**
 * BOC退款订单DTO
 * @author yangyukang
 * @date 2025/1/27
 */
@Data
public class RefundOrderBocDto implements Serializable {

    private static final long serialVersionUID = -1L;

    /**
     * 主键ID
     */
    private Long id;

    /**
     * 商户号
     */
    private String merchantNo;

    /**
     * 商户订单号
     */
    private String orderNo;

    /**
     * 银行交易流水号
     */
    private String bankTranSeq;

    /**
     * 银行订单流水号
     */
    private String orderSeq;

    /**
     * 商户退款交易流水号
     */
    private String brefundSeq;

    /**
     * 处理状态(0:成功 1:失败 2:未知)
     */
    private Integer dealStatus;

    /**
     * 退款金额
     */
    private String refundAmount;

    /**
     * 中行签名数据(JSON格式)
     */
    private String refundJson;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}
