package cn.com.duiba.kjy.paycenter.api.util;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

/**
 * Created by dugq on 2019-03-23.
 */
public class FormatUtils {

    private FormatUtils(){}

    public static String format(String template, Map<String,Object> params){
        if(MapUtils.isEmpty(params)){
            params = new HashMap<>();
        }
        if(StringUtils.isBlank(template)){
            return template;
        }
        StringBuffer sb = new StringBuffer();
        Matcher m = Pattern.compile("\\{\\{.*?\\}\\}").matcher(template);
        while (m.find()) {
            String param = m.group();
            Object value = params.get(param.substring(2, param.length() - 2));
            m.appendReplacement(sb, value==null ? "" : Matcher.quoteReplacement(value.toString()));
        }
        m.appendTail(sb);
        String message = sb.toString();
        message = message.replaceAll("\\[n\\]","\n");
        message = message.replaceAll("\\[s\\]"," ");
        return message;
    }

    public static String formatSkipIfNull(String template, Map<String,Object> params){
        if(MapUtils.isEmpty(params)){
            params = new HashMap<>();
        }
        if(StringUtils.isBlank(template)){
            return template;
        }
        StringBuffer sb = new StringBuffer();
        Matcher m = Pattern.compile("\\{\\{.*?\\}\\}").matcher(template);
        while (m.find()) {
            String param = m.group();
            Object value = params.get(param.substring(2, param.length() - 2));
            if(Objects.nonNull(value)){
                m.appendReplacement(sb, value==null ? "" : Matcher.quoteReplacement(value.toString()));
            }
        }
        m.appendTail(sb);
        String message = sb.toString();
        message = message.replaceAll("\\[n\\]","\n");
        message = message.replaceAll("\\[s\\]"," ");
        return message;
    }

    public static String subLargeString(String source,int maxLength,int shotLength){
        if(StringUtils.isBlank(source) || source.length()<=maxLength){
            return source;
        }
        return source.substring(0,shotLength)+"...";
    }

    public static String quoteReplacement(String title) {
        if (StringUtils.isBlank(title)) {
            return title;
        }

        title = Matcher.quoteReplacement(title);
        title = StringUtils.replaceOnce(title, "\"", "“");
        title = StringUtils.replaceOnce(title, "\"", "”");
        title = StringUtils.replaceOnce(title, "\"", "“");
        title = StringUtils.replaceOnce(title, "\"", "”");
        return title;
    }

    /**
     * 把 a:1,b:2 的字符串转为： {a:1;b:2}的map
     * @param source
     * @return
     */
    public static Map<String,String> formatString2Map(String source){
        Map<String,String> map = new HashMap<>();
        for (String oaIDPic: source.split(",")){
            if(oaIDPic.contains(":")){
                String[] split = oaIDPic.split(":");
                map.put(split[0],split[1]);
            }
        }
        return map;
    }

    public static void main(String[] args) {
        String collect = Arrays.asList("a{{test}}", "b","c").stream().collect(Collectors.joining("[n]"));
        Map map =  new HashMap<>();
        map.put("test","tet[n]te[s]st");
        System.out.println(format(collect,map));
    }

}

