package cn.com.duiba.kjy.paycenter.api.enums.citic;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 中信支付业务种类
 * 文档：http://sitopen.test.citicbank.com:10003/docs/#/interface/qft/citicwallet/IFWAE003?id=%e6%8e%a5%e5%8f%a3%e5%8f%82%e6%95%b0%e8%af%b4%e6%98%8e
 * @author xuzhigang
 * @date 2023/1/12 4:16 下午
 **/
@Getter
@AllArgsConstructor
public enum CiticBizTypeEnum {
    PHYSICAL("100003", "实物消费"),

    VIRTUAL("100001", "虚拟商品购买"),
    ;

    private final String type;

    private final String desc;
}
