package cn.com.duiba.kjy.paycenter.api.remoteservice.config;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.paycenter.api.dto.config.WxpayMchConfDto;
import cn.com.duiba.kjy.paycenter.api.param.PageQuery;

import java.util.List;

/**
 * 微信支付商户配置表
 * @author kjj mybatis generator 
 * @date 2021-06-16
 */
@AdvancedFeignClient
public interface RemoteWxpayMchConfService {

    /**
     * 分页查询
     * @param pageQuery 查询条件
     * @return 微信支付商户配置集合
     */
    List<WxpayMchConfDto> selectPage(PageQuery pageQuery);

    /**
     * 根据条件,查询记录的总记录数
     * @return 符合条件的记录数
     */
    Long selectCount();

    /**
     * 根据主键查询
     * @param id 主键
     * @return 微信支付商户配置
     */
    WxpayMchConfDto selectById(Long id);

    /**
     * 根据商户id查询
     * @param mchId 商户id
     * @return 微信支付商户配置
     */
    WxpayMchConfDto selectByMchId(String mchId);

    /**
     * 新增/更新
     * @param dto 微信支付商户配置
     * @return 执行结果
     */
    int saveOrUpdate(WxpayMchConfDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}