package cn.com.duiba.kvtable.service.api.params;

import cn.com.duiba.kvtable.service.api.enums.HbaseKeySpaceEnum;

import java.io.Serializable;
import java.util.List;

/**
 * 同一空间同一业务定义下批量Increase操作参数
 *
 * Created by sunchangji on 2018/7/3.
 */
public class HbBatchIncreaseParam implements Serializable{

    private static final long serialVersionUID = 634529203102703518L;

    /**
     * key类型
     */
    private HbaseKeySpaceEnum keySpaceEnum;

    /**
     * 客户端自定义的一段key
     */
    private String vkey;

    /**
     * 用户Increase参数,存在就在此基础上增加,不存在就新增记录incrCount为初始值
     */
    private List<HbConsumerIncrParam> consumerIncrParams;

    public HbaseKeySpaceEnum getKeySpaceEnum() {
        return keySpaceEnum;
    }

    public void setKeySpaceEnum(HbaseKeySpaceEnum keySpaceEnum) {
        this.keySpaceEnum = keySpaceEnum;
    }

    public String getVkey() {
        return vkey;
    }

    public void setVkey(String vkey) {
        this.vkey = vkey;
    }

    public List<HbConsumerIncrParam> getConsumerIncrParams() {
        return consumerIncrParams;
    }

    public void setConsumerIncrParams(List<HbConsumerIncrParam> consumerIncrParams) {
        this.consumerIncrParams = consumerIncrParams;
    }
}
