package cn.com.duiba.live.conf.service.api.dto.timebox;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2021-04-15 16:48
 * 直播中宝箱-宝箱奖品预览
 */
@Data
public class LiveTimeBoxPreDetailDto implements Serializable {

    private static final long serialVersionUID = 1961665572245718108L;

    /**
     * 是否配置了红包或实物奖励
     */
    private Boolean confTreasureFlag;

    /**
     * 宝箱开启条件：停留时间（分钟）
     */
    private List<Integer> openCondition;

    /**
     * 宝箱福利：抽奖码数量
     */
    private List<LiveTimeBoxCodeDto> treasureCode;

    /**
     * 宝箱福利：红包
     */
    private List<LiveTimeBoxRedDto> treasureRed;

    /**
     * 宝箱福利：实物
     */
    private List<LiveTimeBoxAwardDto> treasureAward;

}
