package cn.com.duiba.live.conf.service.api.dto.treasure;

import lombok.Data;

import java.io.Serializable;

/**
 * 直播宝箱配置保存对象
 *
 * @author 吴文哲
 * @date 2021/4/9 10:26 上午
 **/
@Data
public class LiveTreasureSaveDto implements Serializable {

    private static final long serialVersionUID = 859260502755748453L;

    /**
     * 直播间id
     */
    private Long liveId;

    /**
     * 宝藏配置Id tb_live_pre_treasure_conf.id
     */
    private Long treasureConfId;

    /**
     * 宝箱场景(业务维度) 1:直播前宝箱 2:直播中宝箱
     *
     * @see cn.com.duiba.live.conf.service.api.enums.treasure.TreasureSceneTypeEnum
     */
    private Integer treasureScene;

    /**
     * 宝箱排序，默认为1
     */
    private Integer treasureSort;

    /**
     * 宝箱周期，1仅直播前，2仅直播中，3直播前和直播中
     *
     * @see cn.com.duiba.live.conf.service.api.enums.treasure.TreasurePeriodTypeEnum
     */
    private Integer treasurePeriod;

    /**
     * 宝箱最大开启次数
     */
    private Integer openNum;

    /**
     * 0:关闭,1:开启
     *
     * @see cn.com.duiba.live.conf.service.api.enums.treasure.TreasureConfStatusEnum
     */
    private Integer confStatus;

    /**
     * 宝箱开启条件，scene:1邀请人数，scene:2观看时长
     */
    private Integer openCondition;

    /**
     * 抽奖码
     */
    private LiveTreasureConfRelatedDto treasureCode;

    /**
     * 红包
     */
    private LiveTreasureConfRelatedDto treasureRed;

    /**
     * 实物奖品
     */
    private LiveTreasureConfRelatedDto treasureAward;
}
