package cn.com.duiba.live.conf.service.api.remoteservice.conf;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.conf.service.api.dto.conf.LiveInteractConfDto;
import cn.com.duiba.live.conf.service.api.param.conf.LiveFreeConfParam;
import cn.com.duiba.live.conf.service.api.param.conf.LiveInteractConfQueryParam;

import java.util.List;
import java.util.Set;

/**
 * 直播互动配置服务rpc类
 * @author 吴文哲
 * @date 2020-04-02 15:27
 **/
@AdvancedFeignClient
public interface RemoteLiveInteractConfApiService {

    /**
     * 根据条件查询
     * @param param
     * @return
     */
    List<LiveInteractConfDto> findByCondition(LiveInteractConfQueryParam param);

    /**
     * 根据条件查询总数
     * @param param
     * @return
     */
    int countByCondition(LiveInteractConfQueryParam param);

    /**
     * 根据主键查询
     * @param id
     * @return
     */
    LiveInteractConfDto selectById(Long id);

    /**
     * 单条插入 返回主键
     * @param dto
     * @return
     */
    Long insert(LiveInteractConfDto dto);

    /**
     * 保存资料配置
     * @param liveId 直播ID
     * @param intreactIdList 互动ID集合
     * @return 执行结果
     */
    int saveResourceConf(Long liveId, List<Long> intreactIdList);

    /**
     * 投票关联资料专用-保存资料配置
     * @param liveId 直播ID
     * @param choiceQuestionIds 投票问题集合
     * @return 执行结果
     */
    int saveResourceConf4Choice(Long liveId, List<Long> choiceQuestionIds);

    /**
     * 批量插入
     * @param dtoList 需要修改的列表
     * @param liveId 直播间id
     * @param interactType 互动类型
     * @return
     */
    Integer batchUpdate(List<LiveInteractConfDto> dtoList,Long liveId,Integer interactType);

    /**
     * 更新
     * @param dto 福利配置信息
     * @return 执行结果
     */
    int update(LiveInteractConfDto dto);

    /**
     * 批量减少剩余数量
     * @param id 主键
     * @param num 减少的数量
     * @return 执行结果
     */
    int batchReduceSurplusNum(Long id, int num);

    /**
     * 获取最近一个未开奖的直播前抽奖配置
     * @param liveId 直播id
     * @return 最近一个未开奖的直播前抽奖配置
     */
    LiveInteractConfDto findLastPreLottery(Long liveId);

    /**
     * 根据主键id查询
     * @param ids 主键id
     * @return 福利配置信息
     */
    List<LiveInteractConfDto> findByIds(Set<Long> ids);

    /**
     * 更新状态
     * @param id 主键
     * @param status 更新状态
     * @param expectedStatus 预期状态
     * @see cn.com.duiba.live.conf.service.api.enums.conf.InteractStatusEnums
     * @return 更新结果
     */
    boolean updateInteractStatus(Long id, Integer status, Integer expectedStatus);

    /**
     * 查询直播所有表单资料ID
     * @param liveId 直播ID
     * @return 资料ID集合
     */
    List<Long> findAllFormResourceId(Long liveId);

    /**
     * 保存或更新免费领
     * @param param 参数
     * @return 主键id
     */
    Long saveOrUpdateFree(LiveFreeConfParam param);

    /**
     * 根据主键软删除
     * @param id 主键
     * @return 执行结果
     */
    boolean deleteById(Long id);
}
