package cn.com.duiba.live.conf.service.api.remoteservice.potential;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.conf.service.api.dto.potential.LivePotentialDialogueConfDto;
import cn.com.duiba.live.conf.service.api.enums.potential.AgentDirectlyEnum;

import java.util.List;

/**
 * 准客户话术
 *
 * @author ZhangJun
 * @date 2021/8/19 6:56 下午
 */
@AdvancedFeignClient
public interface RemoteLivePotentialDialogueService {

    /**
     * 查询指定直播间的话术模版配置
     *
     * @param liveId 直播id
     * @return 话术模版
     */
    List<LivePotentialDialogueConfDto> selectByLiveId(Long liveId);

    /**
     * 批量保存直播话术模版
     *
     * @param liveId 直播id
     * @param dtos 话术模版集合
     * @return 保存结果
     */
    boolean batchSaveDialogue(Long liveId, List<LivePotentialDialogueConfDto> dtos);

    /**
     * 查询指定直播间的一度/多度话术模版配置
     *
     * @param liveId 直播id
     * @param inviteType 人脉邀请类型
     * @return 话术模版
     */
    LivePotentialDialogueConfDto selectByLiveIdAndInviteType(Long liveId, AgentDirectlyEnum inviteType);

}
