package cn.com.duiba.live.conf.service.api.enums.conf;

import com.google.common.collect.Lists;

import java.util.Collections;
import java.util.List;

/**
 * 直播互动状态
 * 同时对应商城商品状态待售、可售、售罄
 * @author 吴文哲
 * @date 2020-04-02 20:37
 **/
public enum InteractStatusEnums {

    NOT_START(0,"未开始（未添加进商品橱窗）"),
    NOT_OPEN(1,"已删除"),
    IN_USE(2,"已上架（可售）"),
    NOT_IN_USE(3,"已下架（待售）"),
    SOLD_OUT(4, "售罄"),
    ;

    /**
     * 状态
     */
    private Integer status;

    /**
     * 描述
     */
    private String desc;

    InteractStatusEnums(Integer status, String desc){
        this.status = status;
        this.desc = desc;
    }

    public Integer getStatus() {
        return status;
    }

    public String getDesc() {
        return desc;
    }

    public static List<Integer> notDeleteStatusList = Lists.newArrayList();

    static {
        notDeleteStatusList.addAll(Lists.newArrayList(NOT_START.getStatus(), IN_USE.getStatus(), NOT_IN_USE.getStatus()));
    }

    /**
     * 已开始的状态列表
     */
    public static List<Integer> startedStatusList = Collections.unmodifiableList(Lists.newArrayList(IN_USE.getStatus(), NOT_IN_USE.getStatus(), SOLD_OUT.getStatus()));
}
