package cn.com.duiba.live.conf.service.api.enums.live;

import com.google.common.collect.ImmutableMap;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * 直播分享类型枚举
 *
 * @author xuzhigang
 * @date 2020/8/8 3:09 下午
 **/
@Getter
@AllArgsConstructor
public enum LiveShareTypeEnum {
    MP_SHARE(1, "直播中常规分享"),
    RED_MP_SHARE(2, "手气王分享"),
    @Deprecated
    PRE_LOTTERY_MP_SHARE(3, "直播前抽奖分享"),
    FISSION_TREASURE_MP_SHARE(4, "裂变宝箱分享"),
    GUESS_NUMBER_MP_SHARE(5, "猜数红包分享"),
    FLIP_CARD_RED_SHARE(6,"翻牌红包分享"),
    PRE_MP_SHARE(7, "直播前常规分享"),
    PASS_QUES_MP_SHARE(8, "闯关答题分享"),
    FORTUNE_RED_MP_SHARE(9, "好运红包分享"),
    FISSION_LOTTERY_MP_SHARE(10, "裂变社交抽奖券分享"),
    ;

    /**
     * 分享类型
     */
    private final Integer type;

    /**
     * 描述
     */
    private final String desc;

    /**
     * 包含所有枚举的map
     */
    private static final ImmutableMap<Integer, LiveShareTypeEnum> ENUM_MAP;

    static {
        Map<Integer, LiveShareTypeEnum> tmpMap = new HashMap<>();
        for (LiveShareTypeEnum typeEnum : values()) {
            tmpMap.put(typeEnum.getType(), typeEnum);
        }
        ENUM_MAP = ImmutableMap.copyOf(tmpMap);
    }

    /**
     * 校验是否是小程序分享
     *
     * @param shareType 分享类型
     * @return true-是小程序分享 false-不是小程序分享
     */
    public static boolean isMpShare(Integer shareType) {
        if(Objects.isNull(shareType)){
            return false;
        }
        return ENUM_MAP.containsKey(shareType);
    }

    /**
     * 获取分享类型枚举
     * @param type 分享类型
     * @return 枚举
     */
    public static LiveShareTypeEnum getByType(Integer type) {
        return ENUM_MAP.get(type);
    }

}
