package cn.com.duiba.live.conf.service.api.remoteservice.resource;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.conf.service.api.dto.resource.ResourcePasterConfigDto;
import cn.com.duiba.live.conf.service.api.param.resource.ResourcePasterConfigSearchParam;

import java.util.List;
import java.util.Set;

/**
 * 资料贴片配置rpc接口
 *
 * @author xuzhigang
 * @date 2020/11/9 10:56 上午
 **/
@AdvancedFeignClient
public interface RemoteResourcePasterConfigApiService {
    /**
     * 根据条件查询 分页
     * @param param 查询条件
     * @return 资料贴片配置集合
     */
    List<ResourcePasterConfigDto> selectPage(ResourcePasterConfigSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    Long selectCount(ResourcePasterConfigSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 资料贴片配置
     */
    ResourcePasterConfigDto selectById(Long id);

    /**
     * 根据直播id查询
     * @param liveId 直播id
     * @return 资料贴片配置集合
     */
    List<ResourcePasterConfigDto> selectListByLiveId(Long liveId);

    /**
     * 根据直播id和资料id查询
     * @param liveId 直播id
     * @param resourceId 资料id
     * @return 资料贴片配置集合
     */
    List<ResourcePasterConfigDto> selectListByLiveIdAndResourceId(Long liveId, Long resourceId);

    /**
     * 保存或者更新
     *
     * @param dto 资料贴片配置
     * @return 执行结果
     */
    int saveOrUpdate(ResourcePasterConfigDto dto);

    /**
     * 逻辑删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 根据直播id查询配置贴片的资料id set
     *
     * @param liveId 直播id
     * @return 资料id
     */
    Set<Long> findResourceIdSetByLiveId(Long liveId);
}
