package cn.com.duiba.live.conf.service.api.enums.conf;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author wangbinbin
 * @create 2021-03-24 11:11
 * @descript 答题领奖状态
 */
@AllArgsConstructor
@Getter
public enum QuestionRewardStatusEnum {

    NOT_ON(0, "未上架"),
    ON(1, "已上架"),
    BEGINNING(2, "发放中"),
    END(3, "已结束"),
    ;

    /**
     * 领奖状态代码
     */
    private final Integer code;

    /**
     * 对应描述
     */
    private final String description;

    /**
     * 可进行删除的状态
     */
    private static List<Integer> canDeleteStatusList = Collections.unmodifiableList(Arrays.asList(NOT_ON.code, ON.code));

    /**
     * 可进行编辑的状态
     */
    private static List<Integer> canEditStatusList = Collections.singletonList(NOT_ON.code);

    /**
     * key=代码 value=枚举对象
     */
    private static Map<Integer, QuestionRewardStatusEnum> codeEnumMap = Collections.unmodifiableMap(
            Arrays.stream(values()).collect(
                    Collectors.toMap(QuestionRewardStatusEnum::getCode, Function.identity())
            ));

    /**
     * 获取可进行删除的状态
     */
    public static List<Integer> getCanDeleteStatusList() {
        return canDeleteStatusList;
    }

    /**
     * 获取可进行编辑的状态
     */
    public static List<Integer> getCanEditStatusList() {
        return canEditStatusList;
    }

    /**
     * 根据代码获取枚举对象
     */
    public static QuestionRewardStatusEnum getEnumByCode(Integer code) {
        if (Objects.isNull(code)) {
            return null;
        }
        return codeEnumMap.get(code);
    }
}
