package cn.com.duiba.live.conf.service.api.remoteservice.conf;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.conf.service.api.dto.conf.LiveOaRelatedDto;
import cn.com.duiba.live.conf.service.api.param.conf.LiveOaRelatedSearchParam;

import java.util.List;

/**
 * 直播公众平台关系表
 * @author kjj mybatis generator 
 * @date 2021-01-21
 */
@AdvancedFeignClient
public interface RemoteLiveOaRelatedApiService {

    /**
     * 分页查询
     * @param param 查询参数
     * @return 关系列表
     */
    List<LiveOaRelatedDto> selectListPage(LiveOaRelatedSearchParam param);

    /**
     * 查询总数
     *
     * @param param 查询参数
     * @return 总数
     */
    Long selectCount(LiveOaRelatedSearchParam param);

    /**
     * 根据公司id查询
     *
     * @param companyId 公司id
     * @return 直播公众平台关系
     */
    LiveOaRelatedDto selectByCompanyId(Long companyId);

    /**
     * 根据公司id激活批量查询
     *
     * @param companyIds 公司id集合
     * @return 直播平台关系集合
     */
    List<LiveOaRelatedDto> selectByCompanyIds(List<Long> companyIds);

    /**
     * 根据oaId和类型查询所属公司
     *
     * @param oaId 公众号id或者企微id
     * @param relatedType {@link cn.com.duiba.live.conf.service.api.enums.conf.LiveOaRelatedTypeEnum}
     * @return 公司id集合
     */
    List<Long> selectCompanyIdsByOaIdAndType(Long oaId, Integer relatedType);

    /**
     * 保存或更新
     *
     * @param dto 平台关系
     * @return 执行结果
     */
    int saveOrUpdateByCompanyId(LiveOaRelatedDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}