/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.live.conf.service.api.enums.live;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;

public enum LiveResourceTypeEnum {
    MATERIAL(1, "\u56fe\u6587\u8d44\u6599"),
    LINK_RESOURCE(9, "\u94fe\u63a5\u8d44\u6599"),
    OA_RESOURCE(10, "\u516c\u4f17\u53f7\u8d44\u6599"),
    FREE_RESOURCE(11, "\u514d\u8d39\u9886\u8d44\u6599"),
    FORM_RESOURCE(12, "\u8868\u5355\u8d44\u6599"),
    TEST_RESOURCE(13, "\u6d4b\u8bd5\u8d44\u6599"),
    GAME_RESOURCE(14, "\u5c0f\u6e38\u620f\u8d44\u6599"),
    EVALUATION_RESOURCE(23, "\u6d4b\u8bc4\u8d44\u6599");

    private static final List<Integer> ALL_TYPES;
    private final Integer type;
    private final String desc;

    public static boolean isResourceInteract(Integer type) {
        return ALL_TYPES.contains(type);
    }

    public Integer getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    private LiveResourceTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    static {
        ALL_TYPES = ListUtils.unmodifiableList(Arrays.stream(LiveResourceTypeEnum.values()).map(LiveResourceTypeEnum::getType).collect(Collectors.toList()));
    }
}

