package cn.com.duiba.live.conf.service.api.dto.mall.goods;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 商城-商品库
 * @author kjj mybatis generator 
 * @date 2022-07-27
 */
@Data
public class MallGoodsDto implements Serializable {
     
    private static final long serialVersionUID = 16589061038599152L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 供应商id，tb_supplier.id
     */
    private Long supplierId;

    /**
     * 选品活动id，tb_pick_activity.id
     */
    private Long pickActivityId;

    /**
     * 商品类型，1=实物,2=虚拟物品
     */
    private Integer goodsType;

    /**
     * 商品名称
     */
    private String goodsName;

    /**
     * 品牌名称
     */
    private String goodsBrand;

    /**
     * 商品类目id，tb_goods_category.id
     */
    private Long categoryId;

    /**
     * 商品主图id集合，tb_common_img.id
     */
    private String mainImgIds;

    /**
     * 商品详情图id集合，tb_common_img.id
     */
    private String detailImgIds;

    /**
     * 发货地
     */
    private String deliveryPlace;

    /**
     * 发货物流
     */
    private String expressCompany;

    /**
     * 是否支持七天无理由退货，0=不支持，1=支持
     */
    private Integer noReasonRefund;

    /**
     * 退货地址及联系方式等信息
     */
    private String refundInfo;

    /**
     * 最低供货价，由选品规格决定，单位：分
     */
    private Long supplierPriceLow;

    /**
     * 最高供货价，由选品规格决定，单位：分
     */
    private Long supplierPriceHigh;

    /**
     * 最低市场价，由选品规格决定，单位：分
     */
    private Long marketPriceLow;

    /**
     * 最高市场价，由选品规格决定，单位：分
     */
    private Long marketPriceHigh;

    /**
     * 最低建议售价，由选品规格决定，单位：分
     */
    private Long suggestPriceLow;

    /**
     * 最高建议售价，由选品规格决定，单位：分
     */
    private Long suggestPriceHigh;

    /**
     * 商品状态,0=禁用，1=启用
     * @see cn.com.duiba.live.conf.service.api.enums.BooleanEnum
     */
    private Integer goodsStatus;

    /**
     * 选品状态,1=待完善，2，待入库，3=已入库
     * @see cn.com.duiba.live.conf.service.api.enums.mall.goods.pick.PickStatusEnum
     */
    private Integer pickStatus;

    /**
     * 是否删除，0=false，1=true
     * @see cn.com.duiba.live.conf.service.api.enums.BooleanEnum
     */
    private Integer deleted;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 入库时间
     */
    private Date warehousingTime;

    /**
     * 商品税率 百分制
     */
    private Integer taxRate;
}