package cn.com.duiba.live.conf.service.api.enums.pub.form;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 公域引流代理商枚举
 *
 * @author xiaocong
 * @date 2021/11/4 6:11 下午
 */
@Getter
@AllArgsConstructor
public enum PubFormAgentEnum {
    /**
     * 其它
     */
    OTHER(0, "", ""),
    /**
     * 信淼
     */
    XM(1, "信淼", "xm"),

    /**
     * 快推
     */
    KT(2, "快推", "kt"),

    /**
     * 天地
     */
    TD(3, "天地", "td"),

    /**
     * 银行个金 使用场景，与流量投放不同
     */
    YHGJ(4, "银行个金", "yhgj"),

    /**
     * 微盟
     */
    WEIMO(5, "微盟", "weimo");

    /**
     * 状态
     */
    private final Integer code;

    /**
     * 描述
     */
    private final String desc;

    /**
     * short
     */
    private final String shortCode;

    public static final Map<Integer, PubFormAgentEnum> AGENT_MAP;

    static {
        Map<Integer, PubFormAgentEnum> map = Arrays.stream(values()).collect(Collectors.toMap(PubFormAgentEnum::getCode, Function.identity()));
        AGENT_MAP = Collections.unmodifiableMap(map);
    }

    /**
     * 通过code获得枚举
     *
     * @param code
     * @return 枚举
     */
    public static PubFormAgentEnum getByCode(Integer code) {
        if (Objects.isNull(code)) {
            return OTHER;
        }
        return AGENT_MAP.get(code);
    }
}
