/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.live.conf.service.api.enums.conf;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum QuestionRewardStatusEnum {
    NOT_ON(0, "\u672a\u4e0a\u67b6"),
    ON(1, "\u5df2\u4e0a\u67b6"),
    BEGINNING(2, "\u53d1\u653e\u4e2d"),
    END(3, "\u5df2\u7ed3\u675f");

    private final Integer code;
    private final String description;
    private static List<Integer> canDeleteStatusList;
    private static List<Integer> canEditStatusList;
    private static Map<Integer, QuestionRewardStatusEnum> codeEnumMap;

    public static List<Integer> getCanDeleteStatusList() {
        return canDeleteStatusList;
    }

    public static List<Integer> getCanEditStatusList() {
        return canEditStatusList;
    }

    public static QuestionRewardStatusEnum getEnumByCode(Integer code) {
        if (Objects.isNull(code)) {
            return null;
        }
        return codeEnumMap.get(code);
    }

    private QuestionRewardStatusEnum(Integer code, String description) {
        this.code = code;
        this.description = description;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    static {
        canDeleteStatusList = Collections.unmodifiableList(Arrays.asList(QuestionRewardStatusEnum.NOT_ON.code, QuestionRewardStatusEnum.ON.code));
        canEditStatusList = Collections.singletonList(QuestionRewardStatusEnum.NOT_ON.code);
        codeEnumMap = Collections.unmodifiableMap(Arrays.stream(QuestionRewardStatusEnum.values()).collect(Collectors.toMap(QuestionRewardStatusEnum::getCode, Function.identity())));
    }
}

