package cn.com.duiba.live.conf.service.api.remoteservice.pub.form;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.conf.service.api.dto.pub.form.PubFormConfDetailDto;
import cn.com.duiba.live.conf.service.api.dto.pub.form.PubFormConfDto;
import cn.com.duiba.live.conf.service.api.param.common.PageQuery;
import cn.com.duiba.live.conf.service.api.param.pub.form.PubFormSelectParam;

import java.util.List;

/**
 * @author zhuenhui
 * @date 2021/09/29 16:20
 * @description 公域流量 - 表单测试 RPC Service
 */
@AdvancedFeignClient
public interface RemotePubFormConfApiService {

    /**
     * 分页查询列表 ( 管理后台专用 )
     *
     * @param param 查询参数
     * @return 测试列表
     */
    @Deprecated
    List<PubFormConfDto> selectPage(PageQuery param);

    /**
     * 按照条件查询 ( 管理后台专用 )
     * @param param 查询参数
     * @return 测试列表
     */
    List<PubFormConfDto> selectPageWithType(PubFormSelectParam param);

    /**
     * 通过条件查询记录的总记录数 ( 管理后台专用 )
     *
     * @param params 查询参数
     * @return 总记录数
     */
    Long selectCountByType(PubFormSelectParam params);

    /**
     * 查询记录的总记录数 ( 管理后台专用 )
     *
     * @return 总记录数
     */
    @Deprecated
    Long selectCount();

    /**
     * 获取表单配置详情 Redis -> DB
     *
     * @param id 表单Id
     * @return 配置详情
     */
    PubFormConfDto findByIdWithCache(Long id);

    /**
     * 新增/更新配置
     *
     * @param confDto 公域流量 - 表单测试配置
     * @return 表单Id
     */
    Long saveOrUpdate(PubFormConfDetailDto confDto);

    /**
     * 逻辑删除
     *
     * @param id 表单Id
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 更新表单状态
     *
     * @param id     表单Id
     * @param status 目标状态
     *               {@link cn.com.duiba.live.conf.service.api.enums.pub.form.PubFormStatusEnum}
     * @return 执行结果
     */
    int updateStatus(Long id, Integer status);


    /**
     * 根据主键id查询
     *
     * @param ids id集合
     * @return 查询结果
     */
    List<PubFormConfDto> listByIds(List<Long> ids);

    /**
     * 查询所有
     * 管理后台专用
     */
    List<PubFormConfDto> listAll();

}
