package cn.com.duiba.live.conf.service.api.enums.mall.marketing;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author zhuenhui
 * @date 2022/11/09 14:50
 * @description 商城 - 支付后营销商品限制类型
 */
@Getter
@AllArgsConstructor
public enum MallMarketingAfterPayGoodsLimitTypeEnum {

    COMMON(1, "全场通用"),
    PARTIALLY_AVAILABLE(2, "部分可用"),
    ;

    private final Integer type;
    private final String desc;

    private static final Map<Integer, MallMarketingAfterPayGoodsLimitTypeEnum> ENUM_MAP = Collections.unmodifiableMap(
            Arrays.stream(values()).collect(Collectors.toMap(
                    MallMarketingAfterPayGoodsLimitTypeEnum::getType,
                    Function.identity(),
                    (v1, v2) -> v2
            ))
    );

    public static MallMarketingAfterPayGoodsLimitTypeEnum getByType(Integer type) {
        return ENUM_MAP.get(type);
    }

}
