package cn.com.duiba.live.conf.service.api.remoteservice.evaluation;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.conf.service.api.dto.evaluation.EvaluationQuestionDto;

import java.util.List;

/**
 * 测评问题
 *
 * @author xuzhigang
 * @date 2021/8/27 3:28 下午
 **/
@AdvancedFeignClient
public interface RemoteEvaluationQuestionService {
    /**
     * 根据ids查询问题列表
     *
     * @param ids ids
     * @return 问题列表
     */
    List<EvaluationQuestionDto> selectListByIds(List<Long> ids);

    /**
     * 根据测试id查询问题列表
     *
     * @param evaluationId 测试id
     * @return 问题列表
     */
    List<EvaluationQuestionDto> selectListByEvaluationId(Long evaluationId);

    /**
     * 批量根据测试id查询问题列表
     *
     * @param evaluationIds 测试id
     * @return 问题集合
     */
    List<EvaluationQuestionDto> batchListByEvaluationIds(List<Long> evaluationIds);
}
