package cn.com.duiba.live.conf.service.api.remoteservice.mall.attribute;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.conf.service.api.dto.mall.attribute.MallAttributeKeyDto;

import java.util.List;

/**
 * 商城-规格属性key，不允许修改操作
 *
 * @author kjj mybatis generator 
 * @date 2022-07-27
 */
@AdvancedFeignClient
public interface RemoteMallAttributeKeyService {
     
    /**
     * 根据条件查询，不分页
     *
     * @param attributeName 属性名称
     * @return 商城-规格属性key，不允许修改操作集合
     */
    List<MallAttributeKeyDto> listByName(String attributeName);

    /**
     * 展示默认属性列表，最多100条，不分页
     *
     * @param attributeType 属性类型
     * @return 默认属性列表
     */
    List<MallAttributeKeyDto> listByType(Integer attributeType);

    /**
     * 根据主键批量查询
     *
     * @param ids 主键id集合
     * @return 属性集合
     */
    List<MallAttributeKeyDto> listByIds(List<Long> ids);

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 商城-规格属性key，不允许修改操作
     */
    MallAttributeKeyDto selectById(Long id);

    /**
     * 新增
     *
     * @param dto 商城-规格属性key，不允许修改操作
     * @return 执行结果
     */
    Long insert(MallAttributeKeyDto dto);

    /**
     * 更新规格属性名称
     *
     * @param dto 商城-规格属性key
     * @return 执行结果
     */
    Boolean update(MallAttributeKeyDto dto);

}