package cn.com.duiba.live.conf.service.api.remoteservice.mall.marketing;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.conf.service.api.dto.mall.marketing.MallMarketingAfterPayConfRelateDto;

import java.util.List;

/**
 * 支付后营销配置关联表
 *
 * @author kjj mybatis generator
 * @date 2022-11-08
 */
@AdvancedFeignClient
public interface RemoteMallMarketingAfterPayConfRelateService {

    /**
     * 根据直播id和商品id查询
     *
     * @param liveId  直播id
     * @param goodsId 商品id
     * @return 支付后营销配置关联
     */
    MallMarketingAfterPayConfRelateDto selectByLiveIdAndGoodsId(Long liveId, Long goodsId);

    /**
     * 根据支付后营销配置id查询
     *
     * @param confIds 支付后营销配置id列表
     * @return 关联关系列表
     */
    List<MallMarketingAfterPayConfRelateDto> listByConfIds(List<Long> confIds);

}