package cn.com.duiba.live.conf.service.api.remoteservice.company;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.conf.service.api.dto.company.LiveCompanySensitiveDto;

/**
 * 公司评论敏感词配置
 * @author lizhi
 * @date 2022/11/16 3:04 下午
 */
@AdvancedFeignClient
public interface RemoteLiveCompanySensitiveService {

    /**
     * 查询通用敏感词，走redis缓存，缓存1个月
     * @return 通用敏感词
     */
    String getCommonWordsCache();

    /**
     * 查询公司配置的敏感词，走redis缓存，缓存1天
     * @param companyId 公司ID
     * @return 公司配置的敏感词
     */
    String getCompanyWordsCache(Long companyId);

    /**
     * 新增或更新通用配置
     * @param sensitiveWords 通用敏感词
     * @return 执行结果
     */
    int insertOrUpdateCommon(String sensitiveWords);

    /**
     * 新增或更新
     * @param dto 公司配置的敏感词
     * @return 执行结果
     */
    int insertOrUpdate(LiveCompanySensitiveDto dto);
}
