package cn.com.duiba.live.conf.service.api.param.mall.coupon;

import cn.com.duiba.live.conf.service.api.param.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 商城-优惠券发放配置
 *
 * @author kjj mybatis generator
 * @date 2022-09-15
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class MallCouponDistributeSearchParam extends PageQuery {

    private static final long serialVersionUID = 1663209875281646L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 优惠券id, tb_mall_coupon.id
     */
    private Long couponId;

    /**
     * 发放类型 1-完成任务发放
     */
    private Byte distributeType;

    /**
     * 任务类型 1-关注直播间 2-累计观看时长 3-预约直播
     */
    private Byte taskType;

    /**
     * 任务完成量
     */
    private Integer taskFinishNum;

    /**
     * 发放方式 1-弹窗提示 2-静默发放
     */
    private Byte distributeWay;

    /**
     * 发放数量, -1代表无限制
     */
    private Integer distributeNum;

    /**
     * 已发放数量
     */
    private Integer userDistributeNum;

    /**
     * 已使用数量
     */
    private Integer userUsedNum;

    /**
     * 发放状态 0-关闭 1-开启
     */
    private Byte distributeStatus;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}