package cn.com.duiba.live.conf.service.api.remoteservice.mall.checklist;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.conf.service.api.dto.mall.checklist.MallGoodsChecklistDto;
import cn.com.duiba.live.conf.service.api.param.mall.checklist.MallGoodsChecklistQueryEsParam;
import cn.com.duiba.live.conf.service.api.param.mall.checklist.MallGoodsChecklistQueryParam;

import java.util.List;
import org.apache.commons.lang3.tuple.Pair;

/**
 * 商城-商品清单
 * @author kjj mybatis generator 
 * @date 2022-07-27
 */
@AdvancedFeignClient
public interface RemoteMallGoodsChecklistService {

    /**
     * es刷数据脚本
     */
    void esScript();

    /**
     * 分页查询
     *
     * @param mallGoodsChecklistQueryParam 商城清单列表入参
     * @return 商城-商品清单集合
     */
    List<MallGoodsChecklistDto> pageList(MallGoodsChecklistQueryParam mallGoodsChecklistQueryParam);

    /**
     * 分页查询
     *
     * @param param 商城清单列表入参
     * @return 商城-商品清单集合
     */
    Pair<Long,List<MallGoodsChecklistDto>> pageListEs(MallGoodsChecklistQueryEsParam param);


    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    Long pageCount(MallGoodsChecklistQueryParam param);

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 商城-商品清单
     */
    MallGoodsChecklistDto selectById(Long id);

    /**
     * 根据名称查询
     *
     * @param checklistName 清单名称
     * @return 查询结果
     */
    MallGoodsChecklistDto findByName(String checklistName);

    /**
     * 新增
     *
     * @param dto 商城-商品清单
     * @return 执行结果
     */
    boolean insert(MallGoodsChecklistDto dto);

    /**
     * 更新
     *
     * @param dto 商城-商品清单
     * @return 执行结果
     */
    boolean update(MallGoodsChecklistDto dto);

    /**
     * 物理删除
     *
     * @param id 主键
     * @return 执行结果
     */
    boolean delete(Long id);
}