package cn.com.duiba.live.conf.service.api.remoteservice.mgm;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.conf.service.api.dto.mgm.MgmActivityConfDto;
import cn.com.duiba.live.conf.service.api.param.mgm.MgmActivityConfSearchParam;

import java.util.List;

/**
 * @author xuzhigang
 * @date 2023/3/15 17:26
 **/
@AdvancedFeignClient
public interface RemoteMgmActivityConfService {
    /**
     * 根据条件查询
     * @param param 查询条件
     * @return mgm活动配置集合
     */
    List<MgmActivityConfDto> selectList(MgmActivityConfSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    Long selectCount(MgmActivityConfSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return mgm活动配置
     */
    MgmActivityConfDto selectById(Long id);

    /**
     * 新增
     * @param dto mgm活动配置
     * @return 活动id
     */
    Long insert(MgmActivityConfDto dto);

    /**
     * 更新
     * @param dto mgm活动配置
     * @return 执行结果
     */
    int update(MgmActivityConfDto dto);
}
