package cn.com.duiba.live.conf.service.api.enums.mall.salegoods;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

import java.util.HashMap;
import java.util.Map;

/**
 * @author xuzhigang
 * @date 2022/8/9 2:14 下午
 **/
@Getter
@AllArgsConstructor
public enum GoodsTypeEnum {

    PHYSICAL(1, "实物商品"),

    VIRTUAL(2, "虚拟商品");

    private final Integer code;

    private final String desc;

    /**
     * 商品类型简称Map
     */
    private static final Map<String, Integer> GOODS_TYPE_STR_MAP = new HashMap<>(2);
    private static final Map<Integer, String> GOODS_TYPE_MAP = new HashMap<>(2);

    static {
        GOODS_TYPE_STR_MAP.put("实物", PHYSICAL.getCode());
        GOODS_TYPE_STR_MAP.put("虚拟", VIRTUAL.getCode());

        GOODS_TYPE_MAP.put(PHYSICAL.getCode(),"实物");
        GOODS_TYPE_MAP.put(VIRTUAL.getCode(),"虚拟");
    }

    /**
     * 商品类型简称列表
     */
    public static Integer getByShortDesc(String desc) {
        if (StringUtils.isBlank(desc)) {
            return null;
        }
        return GOODS_TYPE_STR_MAP.get(desc);
    }

    public static String getDescByType(Integer type){
        return GOODS_TYPE_MAP.get(type);
    }

}
