package cn.com.duiba.live.conf.service.api.enums.voucher;

import lombok.Getter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author dugq
 * @date 2022/1/25 11:24 上午
 */
@Getter
public enum VoucherExtEnum {
    INVITATION_NUM_PER_VOUCHER(1,"每邀请多少人可获得抽奖券"),
    MAX_COUNT_PER_AGENT(2,"每个代理人获得券的上限"),
    ;
    private final Integer code;
    private final String desc;

    VoucherExtEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static final Map<Integer, VoucherExtEnum> ENUM_MAP = new HashMap<>();

    public static final List<Integer> CONF_LIST = new ArrayList<>();

    static{
        for(VoucherExtEnum configEnum : values()){
            ENUM_MAP.put(configEnum.getCode(), configEnum);
            CONF_LIST.add(configEnum.getCode());
        }
    }

    public static VoucherExtEnum getByType(Integer  code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }
}
