package cn.com.duiba.live.conf.service.api.remoteservice.mgm;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.conf.service.api.dto.mgm.LiveMgmPositionDto;

import java.util.List;

/**
 * @author xuzhigang
 * @date 2023/3/16 17:46
 **/
@AdvancedFeignClient
public interface RemoteLiveMgmPositionService {
    /**
     * 根据直播id查询
     * @param liveId 直播id
     * @return 直播-mgm活动资源位集合
     */
    List<LiveMgmPositionDto> selectListByLiveId(Long liveId);

    /**
     * 批量新增
     *
     * @param list 资源位配置
     * @return 执行结果
     */
    int batchInsert(List<LiveMgmPositionDto> list);

    /**
     * 批量更新
     *
     * @param list 资源位配置
     * @return 执行结果
     */
    int batchUpdate(List<LiveMgmPositionDto> list);
}
