package cn.com.duiba.live.conf.service.api.param.bank.card;

import cn.com.duiba.live.conf.service.api.param.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 银行卡链接查询参数
 * @author ouyang
 * @date 2022-09-01
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class BankCardLinkConfSearchParam extends PageQuery {


    private static final long serialVersionUID = -45547576244254162L;
    /**
     * id
     */
    private Long id;

    /**
     * 非id
     */
    private Long notId;

    /**
     * 公司id
     */
    private Long companyId;

    /**
     * 银行卡名称
     */
    private String cardName;

    /**
     * 银行卡名称(准确全匹配)
     */
    private String cardNameAccuracy;

    /**
     * 办卡链接类型,1:h5 2:小程序
     * @see cn.com.duiba.live.conf.service.api.enums.bank.card.BankCardLinkTypeEnum
     */
    private Integer cardLinkType;

}