package cn.com.duiba.live.conf.service.api.remoteservice.live;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.conf.service.api.dto.live.LiveExtDto;

import java.util.List;
import java.util.Map;

/**
 * 直播拓展信息配置rpc接口
 * @author 吴文哲
 * @date 2020-09-09 12:49
 **/
@AdvancedFeignClient
public interface RemoteLiveExtApiService {

    /**
     * 新增/修改直播间配置
     * 没有就新增 存在就修改
     * @param extDto 直播间配置对象
     * @return 保存结果
     */
    boolean saveLiveConfig(LiveExtDto extDto);

    /**
     * 批量新增或更新
     * @param list 拓展配置集合
     * @return 执行结果
     */
    int batchSaveOrUpdate(List<LiveExtDto> list);

    /**
     * 根据直播间id 配置名 获取直播间配置
     * @param liveId 直播间id
     * @param confName 配置名称
     * @return 直播间配置
     */
    LiveExtDto getLiveExtByLiveIdAndConfName(Long liveId,Integer confName);

    /**
     * 根据直播间id 获取直播间配置列表
     * @param liveId 直播间id
     * @param confNameList 配置名称列表
     * @return 直播间配置列表
     */
    List<LiveExtDto> getLiveExtList(Long liveId,List<Integer> confNameList);


    /**
     * 获取直播间拓展配置键值对
     * @param liveId 直播间id
     * @param keys 配置id列表
     * @return 键值对
     */
    Map<Integer, String> getLiveConfigK2ValMap(Long liveId, List<Integer> keys);

    /**
     * 查询直播所有ext配置
     * @param liveId 直播ID
     * @return 键值对
     */
    Map<Integer, String> getLiveAllExtConf(Long liveId);

    /**
     * 批量获取直播间配置
     * @param liveIds 直播间id列表
     * @param confName 配置名称
     * @see cn.com.duiba.live.conf.service.api.enums.conf.LiveExtEnum
     * @return key:liveId val:confVal
     */
    Map<Long,String> getConfValuesByLiveIds(List<Long> liveIds,Integer confName);

    /**
     * 根据直播id和配置名称批量查询
     *
     * @param liveIds 直播iid集合
     * @param confNames 配置名称集合
     * @return 配置
     */
    List<LiveExtDto> getByLiveIdsAndConfNames(List<Long> liveIds, List<Integer> confNames);

    /**
     * 增加已参与直播邀请权限人数
     *
     * @param liveId 直播id
     * @return 执行结果
     */
    int increaseHasJoinNum(Long liveId);

    /**
     * 删除某一个配置
     * @param liveId 直播ID
     * @param confName 配置
     * @return 删除条数
     */
    int deleteByLiveId(Long liveId, Integer confName);
}
