package cn.com.duiba.live.conf.service.api.dto.bank.card;

import java.io.Serializable;
import lombok.Data;

/**
 * 办卡入口配置
 * @author kjj mybatis generator 
 * @date 2022-08-31
 */
@Data
public class ApplyCardConfigDto implements Serializable {

    private static final long serialVersionUID = 1117130467444399756L;
    /**
     * id
     */
    private Long id;

    /**
     * 直播id
     */
    private Long liveId;

    /**
     * 入口类型,1=预告页浮标,2=直播页办卡图标,3=直播间商品橱窗
     * @see cn.com.duiba.live.conf.service.api.enums.bank.card.ApplyCardTypeEnum
     */
    private Integer applyCardType;

    /**
     * 浮标图片oss地址
     */
    private String applyCardBuoy;

    /**
     * 跳转类型,1=银行卡申请页,2=办卡活动页
     * @see cn.com.duiba.live.conf.service.api.enums.bank.card.ApplyCardWayEnum
     */
    private Integer applyCardWay;

    /**
     * 银行卡id/活动id
     */
    private Long confId;
}