package cn.com.duiba.live.conf.service.api.enums.bank.card;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 办卡入口类型枚举
 *
 * @author ZhangJun
 * @date 2022/8/31 11:40
 */
@Getter
@AllArgsConstructor
public enum ApplyCardTypeEnum {
    //后端内部可识别入口
    PREVIEW_ICON(1, "预告页浮标"),
    LIVE_ICON(2, "直播页办卡图标"),
    GOODS_SHELF(3, "直播间商品橱窗"),
    PROJECTX_HAPPY_CLEAR(4,"访客端-星速台-消消乐活动"),
    //前端链接拼接入口
    GOODS_INTERESTS(5,"商品权益"),
    COMPANY_HOME_PAGE(6,"公司首页"),
    ;

    private static final Map<Integer, ApplyCardTypeEnum> ENUM_MAP;
    /**
     * 入口类型
     */
    private final Integer code;

    /**
     * 描述
     */
    private final String desc;


    static {
        ENUM_MAP = Arrays.stream(ApplyCardTypeEnum.values()).collect(Collectors.toMap(ApplyCardTypeEnum::getCode, Function.identity(), (v1, v2) -> v2));
    }

    public static ApplyCardTypeEnum getByType(Integer type) {
        ApplyCardTypeEnum switchEnum = ENUM_MAP.get(type);
        if (Objects.isNull(switchEnum)) {
            return null;
        }
        return switchEnum;
    }
}
