package cn.com.duiba.live.conf.service.api.enums.bank.card;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author zhuenhui
 * @date 2022/11/22 2:50 下午
 * @description 银行持卡限制类型
 */
@Getter
@AllArgsConstructor
public enum BankCardHoldLimitType {

    NOT_LIMITED(1, "不限制"),
    ONLY_CARD_HOLD(2, "仅持卡人购买"),
    ONLY_NO_CARD(3, "仅非持卡人购买"),
    ;


    private final Integer type;
    private final String desc;

    private static final Map<Integer, BankCardHoldLimitType> ENUM_MAP = Collections.unmodifiableMap(
            Arrays.stream(values()).collect(Collectors.toMap(
                    BankCardHoldLimitType::getType,
                    Function.identity(),
                    (v1, v2) -> v2
            ))
    );

    public static BankCardHoldLimitType getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }
}
