package cn.com.duiba.live.conf.service.api.enums.mall.salegoods.related;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.extern.slf4j.Slf4j;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 商品列表-关联商品类型
 * @author lizhi
 * @date 2023/3/7 11:59 上午
 */
@Slf4j
@Getter
@AllArgsConstructor
public enum GoodsListRelatedTypeEnum {
    SALE_GOODS(1, "售卖商品", "tb_mall_sale_spu.id"),
    OUT_GOODS(2, "外部商品", "tb_resource.id"),
    ;

    /**
     * 类型
     */
    private final Integer type;

    /**
     * 描述
     */
    private final String desc;

    /**
     * 关联ID关联说明
     */
    private final String relatedIdDesc;

    private static final Map<Integer, GoodsListRelatedTypeEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(GoodsListRelatedTypeEnum::getType, Function.identity(), (v1,v2) -> {
        log.error("GoodsListRelatedTypeEnum, type distinct, v1.name={}, v2.name={}", v1.name(), v2.name());
        return v2;
    })));

    public static GoodsListRelatedTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }
}
