package cn.com.duiba.live.conf.service.api.enums.pub.form;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author xiaocong
 * @description 公域流量 - 表单测试 状态枚举
 * @date 2021/10/31 1:30 下午
 */

@Getter
@AllArgsConstructor
public enum PubFormChannelEnum {

    /**
     * 其他渠道
     */
    OTHER(0, "", ""),

    /**
     * 今日头条
     */
    TOUTIAO(1, "今日头条", "jrtt"),

    /**
     * 百度
     */
    BAIDU(2, "百度", "bd"),

    /**
     * 微信
     */
    TENCENT(3, "腾讯", "tx"),

    /**
     * 快手
     */
    KUAISHOU(4, "快手", "ks"),

    /**
     * 银行个金 使用场景，与流量投放不同
     */
    YHGJ(5, "银行个金", "yhgj"),

    /**
     * 公众号
     */
    WEIXINMP(6, "公众号", "weixinmp");

    /**
     * 状态
     */
    private final Integer code;

    /**
     * 描述
     */
    private final String desc;

    /**
     * 缩写
     */
    private final String shortCode;


    public static final Map<Integer, PubFormChannelEnum> CHANNEL_MAP;

    static {
        Map<Integer, PubFormChannelEnum> map = Arrays.stream(values()).collect(Collectors.toMap(PubFormChannelEnum::getCode, Function.identity()));
        CHANNEL_MAP = Collections.unmodifiableMap(map);
    }

    /**
     * 通过code获得枚举
     *
     * @param code
     * @return
     */
    public static PubFormChannelEnum getByCode(Integer code) {
        if (Objects.isNull(code)) {
            return OTHER;
        }
        return CHANNEL_MAP.get(code);
    }
}
