package cn.com.duiba.live.conf.service.api.enums.voucher;

import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * @author dugq
 * @date 2022/1/25 11:42 上午
 */
@Getter
public enum VoucherEffectiveScopeEnum {
    ALL_KILL_GOODS(1,"直播间秒杀全部商品"),
    PART_OF_KILL_GOODS(2,"直播间秒杀部分商品"),
    ;
    private final Integer code;

    private final String desc;

    VoucherEffectiveScopeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static final Map<Integer, VoucherEffectiveScopeEnum> ENUM_MAP = new HashMap<>();
    static{
        for(VoucherEffectiveScopeEnum configEnum : values()){
            ENUM_MAP.put(configEnum.getCode(), configEnum);
        }
    }


}
