package cn.com.duiba.live.conf.service.api.param.conf;

import cn.com.duiba.live.conf.service.api.param.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 直播配置-pk奖励
 * @author kjj mybatis generator 
 * @date 2020-03-31
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class LiveConfRewardPkSearchParam extends PageQuery {
     
    private static final long serialVersionUID = 15856387248058148L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 直播ID
     */
    private Long liveId;

    /**
     * 奖品名称
     */
    private String prizeName;

    /**
     * 排名
     */
    private Integer ranking;

    /**
     * 奖励类型，1-个人，2-团队
     */
    private Integer rewardType;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}