package cn.com.duiba.live.conf.service.api.param.mall.salegoods;

import cn.com.duiba.live.conf.service.api.param.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import org.jetbrains.annotations.NotNull;

import java.util.List;


/**
 * @author xuzhigang
 * @date 2023/3/21 11:40
 **/
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class LiveGoodsListRelatedSearchParam extends PageQuery {
    private static final long serialVersionUID = -3424899505491258212L;

    /**
     * 业务id,根据type值对应不同表的ID,见cn.com.duiba.live.conf.service.api.enums.mall.goods.related.GoodsListRelatedBizTypeEnum#bizIdDesc
     */
    @NotNull
    private Long bizId;

    /**
     * 业务类型,1-直播间新人专享,2-公司首页商品
     * @see cn.com.duiba.live.conf.service.api.enums.mall.salegoods.related.GoodsListRelatedBizTypeEnum
     */
    @NotNull
    private Integer bizType;

    /**
     * 商品关联的id,根据type值对应不同表的ID,见cn.com.duiba.live.conf.service.api.enums.mall.goods.related.GoodsListRelatedTypeEnum#relatedIdDesc
     */
    private Long goodsRelatedId;

    /**
     * 商品关联的类型,1-售卖商品,2-外部商品
     * @see cn.com.duiba.live.conf.service.api.enums.mall.salegoods.related.GoodsListRelatedTypeEnum
     */
    private Integer goodsRelatedType;

    /**
     * 商品关联的id,根据type值对应不同表的ID,见cn.com.duiba.live.conf.service.api.enums.mall.goods.related.GoodsListRelatedTypeEnum#relatedIdDesc
     */
    private List<Long> goodsRelatedIds;
}
