package cn.com.duiba.live.conf.service.api.remoteservice.common;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.conf.service.api.dto.common.CommonQuestionDto;
import cn.com.duiba.live.conf.service.api.dto.common.CommonQuestionOptionDto;

import java.util.List;
import java.util.Set;

/**
 * @author liuchao1
 * @version 1.0
 * @date 2020/10/17 11:07
 */
@AdvancedFeignClient
public interface RemoteCommonQuestionApiService {

    /**
     * 根据业务id和业务类型查询
     * @param bizIds 业务id集合
     * @param bizType 业务类型
     * @return 问题配置信息
     */
    List<CommonQuestionDto> findByBizIdsAndType(Set<Long> bizIds, Integer bizType);

    /**
     * 根据业务id和业务类型查询
     * @param bizId 业务id
     * @param bizType 业务类型 {@link cn.com.duiba.live.conf.service.api.enums.common.CommonQuestionBizTypeEnum}
     * @return
     */
    CommonQuestionDto findByBizAndType(Long bizId, Integer bizType);

    /**
     * 根据问题id查询
     * @param quesId 问题id
     * @return 问题选项
     */
    List<CommonQuestionOptionDto> findOptionByQuesId(Long quesId);

    /**
     * 根据问题id查询问题列表
     * @param ids 问题ids
     * @return 问题列表
     */
    List<CommonQuestionDto> findByIds(List<Long> ids);

    /**
     * 根据问题id查询
     * @param id 问题id
     * @return 问题dto
     */
    CommonQuestionDto findById(Long id);

    /**
     * 根据主键硬查询，不管是否逻辑删除
     * 查询历史回答问题时使用，不要用上面的老方法，会出问题
     * @param id 主键
     * @return 通用配置-答题配置
     */
    CommonQuestionDto hardFindById(Long id);
}
