package cn.com.duiba.live.conf.service.api.remoteservice.company;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.conf.service.api.dto.company.LiveCompanyConfDetailDto;
import cn.com.duiba.live.conf.service.api.dto.company.LiveCompanyDto;
import cn.com.duiba.live.conf.service.api.dto.company.LiveCompanyNameDto;
import cn.com.duiba.live.conf.service.api.param.common.ApiPage;
import cn.com.duiba.live.conf.service.api.param.company.LiveCompanyEsSearchParam;
import cn.com.duiba.live.conf.service.api.param.company.LiveCompanySearchParam;
import cn.com.duiba.live.conf.service.api.param.live.OutCreateLiveMpQrCodeParam;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 直播公司服务
 * @author 周舟
 * @date 2020-3-28 10:22:23
 * @version 1.0
 */
@AdvancedFeignClient
public interface RemoteLiveCompanyApiService {


    /**
     * 分页查询
     * @param queryParam 分页查询参数
     * @return 直播公司集合
     */
    ApiPage<LiveCompanyDto> findPageListV2(LiveCompanySearchParam queryParam);

    /**
     * 根据id查询
     * @param id 主键id
     * @return 直播公司
     */
    LiveCompanyDto findById(Long id);

    /**
     * 保存更新直播公司
     * @param dto 直播公司
     * @return 主键，为0，说明新增失败
     */
    Long saveAndUpdate(LiveCompanyDto dto);

    /**
     * 新增或更新（包含配置）
     * @param detailDto 公司及配置信息
     * @return 主键，为null或0说明失败
     */
    Long saveAndUpdateDetail(LiveCompanyConfDetailDto detailDto);

    /**
     * 批量查询
     * @param ids
     * @return
     */
    List<LiveCompanyDto> findByIds(List<Long> ids);

    /**
     * 批量查询(根据公司等级排序，总公司-分公司-中心支分公司)
     * @param ids 主键集合
     * @return 公司集合
     */
    List<LiveCompanyDto> findByIdsOrderByLevel(List<Long> ids);

    /**
     * 根据公司id集合查询公司名称
     * @param ids 公司id集合
     * @return key：公司id value：公司名称
     */
    Map<Long, String> findCompanyNameByIds(List<Long> ids);

    /**
     * 更新公司线索收集员id
     * @param agentId
     * @param id
     * @return
     */
    Integer updateClueCollectorById(Long agentId, Long id);

    /**
     * 根据线索员id 查询公司列表
     * @param agentId
     * @return
     */
    List<LiveCompanyDto> findByClueCollectorId(Long agentId);


    /**
     * 获取生成小程序码的参数（管理员邀请队员）
     * @param companyId 公司ID
     * @return 生成小程序码的参数
     */
    OutCreateLiveMpQrCodeParam getMpQrCodeParamV2(Long companyId);

    /**
     * 更新公司的微信小程序二维码
     * @param companyId 公司ID
     * @param qrCodeUrl 二维码
     * @return 更新结果
     */
    Integer updateQrcodeUrl(Long companyId,String qrCodeUrl);

    /**
     * 更新直播试用账号到期时间
     *
     * @param id 主键id
     * @param authExpiryDate 直播试用账号到期时间
     * @return 更新结果
     */
    Integer updateAuthExpiryDate(Long id, Date authExpiryDate);

    /**
     * 根据公司名获取公司信息，最多返回1000条
     * @param companyName 公司名称
     * @return 公司名称信息
     */
    List<LiveCompanyNameDto> findByCompanyName(String companyName);

    /**
     * 根据条件搜索公司信息，最多返回100条
     * @param searchParam 搜索参数
     * @return 公司名称信息
     */
    List<LiveCompanyNameDto> search(LiveCompanyEsSearchParam searchParam);

    /**
     * 获取公司logo
     * @param companyId 公司ID
     * @return 公司logo
     */
    String getCompanyLogo(Long companyId);

    /**
     * 根据线索员的代理人id 查询公司列表
     * @param clueCollectorIds 线索员代理人id
     * @return 线索员id列表
     */
    List<LiveCompanyDto> findCompanyByClueCollectorIds(List<Long> clueCollectorIds);

    /**
     * 获取第三方公众号公司
     *
     * @return 第三方公司集合
     */
    List<Long> getThirdOaCompanyIds();

    /**
     * 获取第三方平台公司
     *
     * @return 第三方平台
     */
    List<Long> getThirdPlatformCompanyIds();

    /**
     * 查询线索员id
     *
     * @return 线索员id集合
     */
    List<Long> selectClueCollectorIds();

    /**
     * 查询总公司
     *
     * @param id 公司id
     * @return 总公司id
     */
    Long findFirstLevelCompanyById(Long id);

    /**
     * 根据id删除公司
     *
     * @param id 主键id
     * @return 是否删除
     */
    Integer deleteById(Long id);

    /**
     * 判断当前公司是否是中国人寿财险下的公司
     *
     * @param companyId 公司id
     * @return true-是 false-不是
     */
    boolean isChinaLifePcCompany(Long companyId);

    /**
     * 代理人维度客户线索统计白名单
     * @return 需要统计的公司ID集合
     */
    Set<Long> liveAgentCustomerStatWhiteList();
}
