package cn.com.duiba.live.conf.service.api.remoteservice.goods;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.conf.service.api.dto.goods.LiveCouponsDto;

import java.util.List;

/**
 * 直播秒杀商品优惠券
 *
 * @author ZhangJun
 * @date 2021/12/9 2:56 下午
 */
@AdvancedFeignClient
public interface RemoteLiveCouponsService {

    /**
     * 根据主键id查询(含已逻辑删除的)
     *
     * @param id 主键id
     * @return 优惠券信息
     */
    LiveCouponsDto findById(Long id);

    /**
     * 根据主键id批量查询(含已逻辑删除的)
     *
     * @param ids 主键id集合
     * @return 优惠券列表
     */
    List<LiveCouponsDto> findByIds(List<Long> ids);

    /**
     * 根据直播id查询所有优惠券(不含已逻辑删除的)
     *
     * @param liveId 直播id
     * @return 优惠券列表
     */
    List<LiveCouponsDto> listByLiveId(Long liveId);

    /**
     * 根据直播id+秒杀商品配置id查询优惠券
     *
     * @param liveId      直播id
     * @param goodsConfId 秒杀商品配置id
     * @return 优惠券信息
     */
    LiveCouponsDto findByLiveAndGoodsId(Long liveId, Long goodsConfId);

    /**
     * 根据秒杀商品配置id查询优惠券
     *
     * @param goodsConfId 秒杀商品配置id
     * @return 优惠券信息
     */
    LiveCouponsDto findByGoodsConfId(Long goodsConfId);

    /**
     * 批量根据秒杀商品配置id查询优惠券
     *
     * @param goodsConfIds 秒杀商品配置id集合
     * @return 优惠券信息
     */
    List<LiveCouponsDto> batchFindByGoodsConfIds(List<Long> goodsConfIds);

    /**
     * 根据直播id+关联资料配置id查询所有优惠券
     *
     * @param liveId         直播id
     * @param resourceConfId 资料配置id
     * @return 优惠券列表
     */
    List<LiveCouponsDto> listByLiveAndResourceConfId(Long liveId, Long resourceConfId);

    /**
     * 新增优惠券
     *
     * @param dto 优惠券信息
     * @return 新增结果
     */
    boolean insert(LiveCouponsDto dto);

    /**
     * 修改优惠券信息(券后价、领取方式、关联资料配置id)
     *
     * @param dto 优惠券信息
     * @return 修改结果
     */
    boolean update(LiveCouponsDto dto);

    /**
     * 根据主键id逻辑删除优惠券
     *
     * @param id 主键id
     * @return 删除结果
     */
    boolean logicDelete(Long id);

}
