package cn.com.duiba.live.conf.service.api.remoteservice.mall.salegoods;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.conf.service.api.dto.mall.salegoods.LiveGoodsListRelatedDetailDto;
import cn.com.duiba.live.conf.service.api.dto.mall.salegoods.LiveGoodsListRelatedDto;
import cn.com.duiba.live.conf.service.api.param.mall.salegoods.LiveGoodsListRelatedSearchParam;

import java.util.List;

/**
 * 商品列表关联关系
 * @author lizhi
 * @date 2023/3/8 2:24 下午
 */
@AdvancedFeignClient
public interface RemoteLiveGoodsListRelatedService {

    /**
     * 导入商品
     * @param bizId 业务id,根据type值对应不同表的ID,见cn.com.duiba.live.conf.service.api.enums.mall.goods.related.GoodsListRelatedBizTypeEnum#bizIdDesc
     * @param bizType 业务类型,1-直播间新人专享,2-公司首页商品
     * @see cn.com.duiba.live.conf.service.api.enums.mall.salegoods.related.GoodsListRelatedBizTypeEnum
     * @param goodsRelatedIdList 商品关联的id列表，见GoodsListRelatedTypeEnum.relatedIdDesc
     * @param goodsRelatedType 商品关联的类型
     * @see cn.com.duiba.live.conf.service.api.enums.mall.salegoods.related.GoodsListRelatedTypeEnum
     * @return 是否成功
     */
    boolean importGoods(Long bizId, Integer bizType, List<Long> goodsRelatedIdList, Integer goodsRelatedType);

    /**
     * 根据业务ID查询，redis缓存
     * @param bizId 业务id,根据type值对应不同表的ID,见cn.com.duiba.live.conf.service.api.enums.mall.goods.related.GoodsListRelatedBizTypeEnum#bizIdDesc
     * @param bizType 业务类型,1-直播间新人专享,2-公司首页商品
     * @see cn.com.duiba.live.conf.service.api.enums.mall.salegoods.related.GoodsListRelatedBizTypeEnum
     * @return 商品列表关联集合
     */
    List<LiveGoodsListRelatedDto> selectByBizCache(Long bizId, Integer bizType);

    /**
     * 根据业务ID查询，包含商品详细信息
     * @param bizId 业务id,根据type值对应不同表的ID,见cn.com.duiba.live.conf.service.api.enums.mall.goods.related.GoodsListRelatedBizTypeEnum#bizIdDesc
     * @param bizType 业务类型,1-直播间新人专享,2-公司首页商品
     * @see cn.com.duiba.live.conf.service.api.enums.mall.salegoods.related.GoodsListRelatedBizTypeEnum
     * @return 商品列表关联集合
     */
    List<LiveGoodsListRelatedDetailDto> selectDetailByBiz(Long bizId, Integer bizType);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 商品列表关联
     */
    LiveGoodsListRelatedDto selectById(Long id);

    /**
     * 移除商品
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 置顶
     *
     * @param id 主键id
     * @return 执行结果
     */
    boolean top(Long id);

    /**
     * 分页查询
     *
     * @param param 查询参数
     * @return 列表
     */
    List<LiveGoodsListRelatedDto> selectPageList(LiveGoodsListRelatedSearchParam param);

    /**
     * 分页查询，包含商品详细信息
     * @param param 查询参数
     * @see cn.com.duiba.live.conf.service.api.enums.mall.salegoods.related.GoodsListRelatedBizTypeEnum
     * @return 商品列表关联集合
     */
    List<LiveGoodsListRelatedDetailDto> selectDetailByPageParam(LiveGoodsListRelatedSearchParam param);

    /**
     * 查询数量
     *
     * @param param 查询参数
     * @return 数量
     */
    Long selectCount(LiveGoodsListRelatedSearchParam param);
}
